//
//  AHKMultiValue.h
//  AH-K3001V Utilities
//
//  Created by Fujidana on Fri Feb 18 2005.
//  Copyright (c) 2005 Fujidana Kobo. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum {
	AHKPHSEmailType = 0,
	AHKCellularEmailType = 1,
	AHKHomeEmailType = 2,
	AHKWorkEmailType = 3,
	AHKSchoolEmailType = 4,
	AHKOtherEmailType = 5
} AHKEmailType;

typedef enum {
	AHKPHSPhoneType = 0, 
	AHKCellularPhoneType = 1, 
	AHKHomePhoneType = 2, 
	AHKWorkPhoneType = 3, 
	AHKFaxPhoneType = 4, 
	AHKOtherPhoneType = 5
} AHKPhoneType;

@interface AHKMultiValue : NSObject <NSCoding, NSCopying> {
	int			firstLabel;
	NSString	*firstValue;
	int			secondLabel;
	NSString	*secondValue;
	int			thirdLabel;
	NSString	*thirdValue;
	
	unsigned	indexForPreferredValue;
}

- (int)firstLabel;
- (void)setFirstLabel:(int)value;

- (NSString *)firstValue;
- (void)setFirstValue:(NSString *)value;
- (BOOL)validateFirstValue:(id *)ioValue error:(NSError **)outError;

- (int)secondLabel;
- (void)setSecondLabel:(int)value;

- (NSString *)secondValue;
- (void)setSecondValue:(NSString *)value;
- (BOOL)validateSecondValue:(id *)ioValue error:(NSError **)outError;

- (int)thirdLabel;
- (void)setThirdLabel:(int)value;

- (NSString *)thirdValue;
- (void)setThirdValue:(NSString *)value;
- (BOOL)validateThirdValue:(id *)ioValue error:(NSError **)outError;

- (unsigned)indexForPreferredValue;
- (void)setIndexForPreferredValue:(unsigned)index;

- (int)preferredLabel;
- (void)setPreferredLabel:(int)value;

- (NSString *)preferredValue;
- (void)setPreferredValue:(NSString *)value;
- (BOOL)validatePreferredValue:(id *)ioValue error:(NSError **)outError;

//- (unsigned int)count;
- (int)labelAtIndex:(unsigned)index;
- (void)setLabel:(int)value atIndex:(unsigned)index;
- (NSString *)valueAtIndex:(unsigned)index;
- (void)setValue:(NSString *)value atIndex:(unsigned)index;

- (BOOL)addValue:(NSString *)value withLabel:(int)label preferred:(BOOL)flag;
- (BOOL)addValue:(NSString *)value withLabelString:(NSString *)labelString preferred:(BOOL)flag;

//- (BOOL)insertValue:(NSString *)value withLabel:(NSString *)label;
//- (BOOL)removeValueAndLabelAtIndex:(int)index;

// subclass must override these 3 methods
- (BOOL)validateValue:(id *)ioValue error:(NSError **)outError;
- (NSString *)labelStringAtIndex:(unsigned)index;
- (void)setLabelString:(NSString *)value atIndex:(unsigned)index;

@end

@interface AHKEmailAddresses : AHKMultiValue {
}
- (BOOL)validateValue:(id *)ioValue error:(NSError **)outError;
- (NSString *)labelStringAtIndex:(unsigned)index;
- (void)setLabelString:(NSString *)value atIndex:(unsigned)index;
@end

@interface AHKPhoneNumbers : AHKMultiValue {
}
- (BOOL)validateValue:(id *)ioValue error:(NSError **)outError;
- (NSString *)labelStringAtIndex:(unsigned)index;
- (void)setLabelString:(NSString *)value atIndex:(unsigned)index;
@end